<?php
// Send broadcast request to search cameras
function OnvifDiscovery($sock)
{
   $str = "ONVIF Discovery";
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
// Clear List of broadcast responses from cameras
function OnvifDiscoveryClear($sock)
{
   $str = "ONVIF Clear";
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
// Call Server Plug'n'Play ONVIF Master function
function OnvifMaster($sock)
{
   $str = "ONVIF Master";
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
// Change Camera IP
function OnvifChangeCameraIP($sock, $camcurip, $camport, $camnewip, $prefixLength)
{
   $str = "ONVIF ChangeCameraIP " . $camcurip . " " . $camport . " " . $camnewip . " " . $prefixLength;
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
// Ping
function OnvifPing($sock, $pingip1, $pingip2, $pingprefixLength)
{
   $str = "ONVIF PingRange " . $pingip1 . " " . $pingip2 . " " . $pingprefixLength;
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
// Conflict Resolver
function OnvifConflictResolve($sock, $pingip1, $pingip2, $pingprefixLength)
{
   $str = "ONVIF ConflictResolve " . $pingip1 . " " . $pingip2 . " " . $pingprefixLength;
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
// Set all to the same IP/prefilxLength
function OnvifConflictMake($sock, $pingip1, $pingip2, $pingprefixLength)
{
   $str = "ONVIF ConflictMake " . $pingip1 . " " . $pingip2 . " " . $pingprefixLength;
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
// Check IP address conflict between server cam interfaces and cameras (No conflicts is needed for OnvifDiscovery correct work)
function OnvifARPProbe($sock, $devno)
{
   $str = "ONVIF ARPProbe " . $devno;
   Send($sock, $str);
   $response = Recv($sock);
   return $response == "true";
}
